/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.ras;

import com.ibm.ras.RASIEvent;
import com.ibm.ras.RASMessageCatalog;
import com.ibm.ras.RASMessageEvent;
import com.ibm.ras.RASMessageFormatter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.MissingResourceException;

public class ConsoleFormatter
extends RASMessageFormatter {
    public ConsoleFormatter() {
        this.setSeparator(":");
        this.setDateFormat(new SimpleDateFormat("yyyy.MM.dd"));
        this.setTimeFormat(new SimpleDateFormat("HH:mm:ss"));
        this.getDate(0L);
    }

    public String format(RASIEvent rASIEvent) {
        RASMessageEvent rASMessageEvent = (RASMessageEvent)rASIEvent;
        StringBuffer stringBuffer = new StringBuffer(256);
        Exception exception = (Exception)rASIEvent.getAttribute("exception");
        Object[] objectArray = rASIEvent.getParameters();
        long l = rASMessageEvent.getTimeStamp();
        stringBuffer.append(this.getTime(l)).append(' ');
        long l2 = rASIEvent.getType();
        if (exception != null) {
            stringBuffer.append("<X> ");
        } else if (l2 == 1L) {
            stringBuffer.append("<I> ");
        } else if (l2 == 2L) {
            stringBuffer.append("<W> ");
        } else if (l2 == 4L) {
            stringBuffer.append("<E> ");
        } else {
            stringBuffer.append("<?> ");
        }
        if (exception == null) {
            String string = rASMessageEvent.getMessageFile();
            if (string == null) {
                stringBuffer.append("- ").append(rASMessageEvent.getText());
            } else {
                try {
                    RASMessageCatalog rASMessageCatalog = new RASMessageCatalog(string);
                    stringBuffer.append("- ").append(rASMessageCatalog.getMessage(rASMessageEvent.getText(), objectArray));
                }
                catch (MissingResourceException missingResourceException) {
                    stringBuffer.append("Error accessing message catalog");
                }
            }
        } else {
            StringWriter stringWriter = new StringWriter();
            exception.printStackTrace(new PrintWriter(stringWriter));
            stringBuffer.append(" - ").append(stringWriter.toString());
        }
        return stringBuffer.toString();
    }
}

